package org.kodein.emoji.people_body.person_activity

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonRunning: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🏃",
        description = "person running",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("person-running", "running"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-activity: person running.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonRunning: SkinTone1Emoji get() = _PersonRunning

/**
 * Alias to emoji [PersonRunning] (People & Body: person-activity: person running).
*/
public val Emoji.Companion.Running: SkinTone1Emoji get() = _PersonRunning
