package org.kodein.emoji.smileys_emotion.cat_face

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _CryingCat: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😿",
        description = "crying cat",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("crying-cat", "crying-cat-face"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: cat-face: crying cat.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CryingCat: Emoji get() = _CryingCat

/**
 * Alias to emoji [CryingCat] (Smileys & Emotion: cat-face: crying cat).
*/
public val Emoji.Companion.CryingCatFace: Emoji get() = _CryingCat
