package org.kodein.emoji.smileys_emotion.face_neutral_skeptical

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FaceExhaling: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😮‍💨",
        description = "face exhaling",
        unicodeVersion = UnicodeVersion(13, 1),
        aliases = listOf("face-exhaling", "exhale"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-neutral-skeptical: face exhaling.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FaceExhaling: Emoji get() = _FaceExhaling

/**
 * Alias to emoji [FaceExhaling] (Smileys & Emotion: face-neutral-skeptical: face exhaling).
*/
public val Emoji.Companion.Exhale: Emoji get() = _FaceExhaling
