package org.kodein.emoji.smileys_emotion.face_neutral_skeptical

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _NeutralFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😐",
        description = "neutral face",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("neutral-face", ),
        emoticons = listOf(":|"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-neutral-skeptical: neutral face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.NeutralFace: Emoji get() = _NeutralFace
