package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _InputLatinUppercase: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔠",
        description = "input latin uppercase",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("input-latin-uppercase", "uppercase-letters"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: alphanum: input latin uppercase.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.InputLatinUppercase: Emoji get() = _InputLatinUppercase

/**
 * Alias to emoji [InputLatinUppercase] (Symbols: alphanum: input latin uppercase).
*/
public val Emoji.Companion.UppercaseLetters: Emoji get() = _InputLatinUppercase
