package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _JapaneseVacancyButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🈳",
        description = "Japanese “vacancy” button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("japanese-vacancy-button", "vacancy"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: alphanum: Japanese “vacancy” button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.JapaneseVacancyButton: Emoji get() = _JapaneseVacancyButton

/**
 * Alias to emoji [JapaneseVacancyButton] (Symbols: alphanum: Japanese “vacancy” button).
*/
public val Emoji.Companion.Vacancy: Emoji get() = _JapaneseVacancyButton
