package org.kodein.emoji.travel_places.place_geographic

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllPlaceGeographic() {
    add(intArrayOf(0x26f0, 0xfe0f), _Mountain)
    add(intArrayOf(0x26f0), _Mountain)
    add(intArrayOf(0x1f3d4, 0xfe0f), _SnowCappedMountain)
    add(intArrayOf(0x1f3d4), _SnowCappedMountain)
    add(intArrayOf(0x1f30b), _Volcano)
    add(intArrayOf(0x1f3dc, 0xfe0f), _Desert)
    add(intArrayOf(0x1f3dc), _Desert)
    add(intArrayOf(0x1f3de, 0xfe0f), _NationalPark)
    add(intArrayOf(0x1f3de), _NationalPark)
    add(intArrayOf(0x1f3dd, 0xfe0f), _DesertIsland)
    add(intArrayOf(0x1f3dd), _DesertIsland)
    add(intArrayOf(0x1f3d6, 0xfe0f), _BeachWithUmbrella)
    add(intArrayOf(0x1f3d6), _BeachWithUmbrella)
    add(intArrayOf(0x1f5fb), _MountFuji)
    add(intArrayOf(0x1f3d5, 0xfe0f), _Camping)
    add(intArrayOf(0x1f3d5), _Camping)
}

internal fun MutableList<Emoji>.addAllPlaceGeographic() {
    add(_Mountain)
    add(_SnowCappedMountain)
    add(_Volcano)
    add(_Desert)
    add(_NationalPark)
    add(_DesertIsland)
    add(_BeachWithUmbrella)
    add(_MountFuji)
    add(_Camping)
}

/**
 * All Emoji of the Travel & Places: place-geographic subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allPlaceGeographic(): List<Emoji> =
    ArrayList<Emoji>(9).apply { addAllPlaceGeographic() }
