package org.kodein.emoji.travel_places.place_other

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SunriseOverMountains: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🌄",
        description = "sunrise over mountains",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("sunrise-over-mountains", ),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Travel & Places: place-other: sunrise over mountains.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SunriseOverMountains: Emoji get() = _SunriseOverMountains
