package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagGhana: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇬🇭",
        description = "flag: Ghana",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-ghana", "ghana-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Ghana.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagGhana: Emoji get() = _FlagGhana

/**
 * Alias to emoji [FlagGhana] (Flags: country-flag: flag: Ghana).
*/
public val Emoji.Companion.GhanaFlag: Emoji get() = _FlagGhana
