package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagLaos: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇱🇦",
        description = "flag: Laos",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-laos", "laos-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Laos.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagLaos: Emoji get() = _FlagLaos

/**
 * Alias to emoji [FlagLaos] (Flags: country-flag: flag: Laos).
*/
public val Emoji.Companion.LaosFlag: Emoji get() = _FlagLaos
