package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagMorocco: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇲🇦",
        description = "flag: Morocco",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-morocco", "morocco-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Morocco.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagMorocco: Emoji get() = _FlagMorocco

/**
 * Alias to emoji [FlagMorocco] (Flags: country-flag: flag: Morocco).
*/
public val Emoji.Companion.MoroccoFlag: Emoji get() = _FlagMorocco
