package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagRomania: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇷🇴",
        description = "flag: Romania",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-romania", "romania-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Romania.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagRomania: Emoji get() = _FlagRomania

/**
 * Alias to emoji [FlagRomania] (Flags: country-flag: flag: Romania).
*/
public val Emoji.Companion.RomaniaFlag: Emoji get() = _FlagRomania
