package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagTaiwan: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇹🇼",
        description = "flag: Taiwan",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-taiwan", "taiwan-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Taiwan.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagTaiwan: Emoji get() = _FlagTaiwan

/**
 * Alias to emoji [FlagTaiwan] (Flags: country-flag: flag: Taiwan).
*/
public val Emoji.Companion.TaiwanFlag: Emoji get() = _FlagTaiwan
