package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagTristanDaCunha: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇹🇦",
        description = "flag: Tristan da Cunha",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-tristan-da-cunha", "tristan-da-cunha-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Tristan da Cunha.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagTristanDaCunha: Emoji get() = _FlagTristanDaCunha

/**
 * Alias to emoji [FlagTristanDaCunha] (Flags: country-flag: flag: Tristan da Cunha).
*/
public val Emoji.Companion.TristanDaCunhaFlag: Emoji get() = _FlagTristanDaCunha
