package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _RescueWorkersHelmet: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⛑️",
        description = "rescue worker’s helmet",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("rescue-workers-helmet", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: clothing: rescue worker’s helmet.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RescueWorkersHelmet: Emoji get() = _RescueWorkersHelmet
