package org.kodein.emoji.people_body.hand_fingers_partial

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllHandFingersPartial() {
    add(intArrayOf(0x1f91f), _LoveYouGesture)
    addVariations(intArrayOf(0x1f91f, 0x0), _LoveYouGesture, 1)
    add(intArrayOf(0x1f918), _SignOfTheHorns)
    addVariations(intArrayOf(0x1f918, 0x0), _SignOfTheHorns, 1)
    add(intArrayOf(0x270c, 0xfe0f), _VictoryHand)
    add(intArrayOf(0x270c), _VictoryHand)
    addVariations(intArrayOf(0x270c, 0x0), _VictoryHand, 1)
    add(intArrayOf(0x1f91e), _CrossedFingers)
    addVariations(intArrayOf(0x1f91e, 0x0), _CrossedFingers, 1)
    add(intArrayOf(0x1faf0), _HandWithIndexFingerAndThumbCrossed)
    addVariations(intArrayOf(0x1faf0, 0x0), _HandWithIndexFingerAndThumbCrossed, 1)
    add(intArrayOf(0x1f919), _CallMeHand)
    addVariations(intArrayOf(0x1f919, 0x0), _CallMeHand, 1)
    add(intArrayOf(0x1f90c), _PinchedFingers)
    addVariations(intArrayOf(0x1f90c, 0x0), _PinchedFingers, 1)
    add(intArrayOf(0x1f90f), _PinchingHand)
    addVariations(intArrayOf(0x1f90f, 0x0), _PinchingHand, 1)
    add(intArrayOf(0x1f44c), _OkHand)
    addVariations(intArrayOf(0x1f44c, 0x0), _OkHand, 1)
}

internal fun MutableList<Emoji>.addAllHandFingersPartial() {
    add(_LoveYouGesture)
    add(_SignOfTheHorns)
    add(_VictoryHand)
    add(_CrossedFingers)
    add(_HandWithIndexFingerAndThumbCrossed)
    add(_CallMeHand)
    add(_PinchedFingers)
    add(_PinchingHand)
    add(_OkHand)
}

/**
 * All Emoji of the People & Body: hand-fingers-partial subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allHandFingersPartial(): List<Emoji> =
    ArrayList<Emoji>(9).apply { addAllHandFingersPartial() }
