package org.kodein.emoji.smileys_emotion.face_sleepy

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SleepyFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😪",
        description = "sleepy face",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("sleepy-face", "sleepy"),
        emoticons = listOf("(-.-)zzZZ"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-sleepy: sleepy face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SleepyFace: Emoji get() = _SleepyFace

/**
 * Alias to emoji [SleepyFace] (Smileys & Emotion: face-sleepy: sleepy face).
*/
public val Emoji.Companion.Sleepy: Emoji get() = _SleepyFace
