package org.kodein.emoji.travel_places.sky_weather

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FullMoonFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🌝",
        description = "full moon face",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("full-moon-face", "moon-face-full"),
        emoticons = listOf("<_<"),
        notoAnimated = false,
    ),
)

/**
 * Emoji Travel & Places: sky & weather: full moon face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FullMoonFace: Emoji get() = _FullMoonFace

/**
 * Alias to emoji [FullMoonFace] (Travel & Places: sky & weather: full moon face).
*/
public val Emoji.Companion.MoonFaceFull: Emoji get() = _FullMoonFace
