package org.kodein.emoji.travel_places.time

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _TwelveOclock: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🕛",
        description = "twelve o’clock",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("twelve-oclock", "twelve-o-clock"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Travel & Places: time: twelve o’clock.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.TwelveOclock: Emoji get() = _TwelveOclock

/**
 * Alias to emoji [TwelveOclock] (Travel & Places: time: twelve o’clock).
*/
public val Emoji.Companion.TwelveOClock: Emoji get() = _TwelveOclock
