package org.kodein.emoji.activities

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.activities.game.*
import org.kodein.emoji.activities.arts_crafts.*
import org.kodein.emoji.activities.event.*
import org.kodein.emoji.activities.sport.*
import org.kodein.emoji.activities.award_medal.*


internal fun EmojiFinder.addAllActivities() {
    addAllGame()
    addAllArtsCrafts()
    addAllEvent()
    addAllSport()
    addAllAwardMedal()
}

internal fun MutableList<Emoji>.addAllActivities() {
    addAllGame()
    addAllArtsCrafts()
    addAllEvent()
    addAllSport()
    addAllAwardMedal()
}

/**
 * All Emoji of the Activities group.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allActivities(): List<Emoji> =
    ArrayList<Emoji>(85).apply { addAllActivities() }

internal fun allActivitiesSubgroups(): Map<String, () -> List<Emoji>> =
    mapOf(
        "game" to { Emoji.allGame() },
        "arts_crafts" to { Emoji.allArtsCrafts() },
        "event" to { Emoji.allEvent() },
        "sport" to { Emoji.allSport() },
        "award_medal" to { Emoji.allAwardMedal() },
    )
