package org.kodein.emoji.activities.arts_crafts

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SewingNeedle: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🪡",
        description = "sewing needle",
        unicodeVersion = UnicodeVersion(13, 0),
        aliases = listOf("sewing-needle", "needle"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Activities: arts & crafts: sewing needle.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SewingNeedle: Emoji get() = _SewingNeedle

/**
 * Alias to emoji [SewingNeedle] (Activities: arts & crafts: sewing needle).
*/
public val Emoji.Companion.Needle: Emoji get() = _SewingNeedle
