package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagAndorra: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇦🇩",
        description = "flag: Andorra",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-andorra", "andorra-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Andorra.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagAndorra: Emoji get() = _FlagAndorra

/**
 * Alias to emoji [FlagAndorra] (Flags: country-flag: flag: Andorra).
*/
public val Emoji.Companion.AndorraFlag: Emoji get() = _FlagAndorra
