package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagBosniaHerzegovina: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇧🇦",
        description = "flag: Bosnia & Herzegovina",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-bosnia-herzegovina", "bosnia-herzegovina-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Bosnia & Herzegovina.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagBosniaHerzegovina: Emoji get() = _FlagBosniaHerzegovina

/**
 * Alias to emoji [FlagBosniaHerzegovina] (Flags: country-flag: flag: Bosnia & Herzegovina).
*/
public val Emoji.Companion.BosniaHerzegovinaFlag: Emoji get() = _FlagBosniaHerzegovina
