package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagDiegoGarcia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇩🇬",
        description = "flag: Diego Garcia",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-diego-garcia", "diego-garcia-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Diego Garcia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagDiegoGarcia: Emoji get() = _FlagDiegoGarcia

/**
 * Alias to emoji [FlagDiegoGarcia] (Flags: country-flag: flag: Diego Garcia).
*/
public val Emoji.Companion.DiegoGarciaFlag: Emoji get() = _FlagDiegoGarcia
