package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagGrenada: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇬🇩",
        description = "flag: Grenada",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-grenada", "grenada-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Grenada.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagGrenada: Emoji get() = _FlagGrenada

/**
 * Alias to emoji [FlagGrenada] (Flags: country-flag: flag: Grenada).
*/
public val Emoji.Companion.GrenadaFlag: Emoji get() = _FlagGrenada
