package org.kodein.emoji.people_body.person

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonBlondHair: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "👱",
        description = "person: blond hair",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("person-blond-hair", "blond-hair"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person: person: blond hair.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonBlondHair: SkinTone1Emoji get() = _PersonBlondHair

/**
 * Alias to emoji [PersonBlondHair] (People & Body: person: person: blond hair).
*/
public val Emoji.Companion.BlondHair: SkinTone1Emoji get() = _PersonBlondHair
