package org.kodein.emoji.smileys_emotion.cat_face

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _GrinningCatWithSmilingEyes: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😸",
        description = "grinning cat with smiling eyes",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("grinning-cat-with-smiling-eyes", "smile-cat"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: cat-face: grinning cat with smiling eyes.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.GrinningCatWithSmilingEyes: Emoji get() = _GrinningCatWithSmilingEyes

/**
 * Alias to emoji [GrinningCatWithSmilingEyes] (Smileys & Emotion: cat-face: grinning cat with smiling eyes).
*/
public val Emoji.Companion.SmileCat: Emoji get() = _GrinningCatWithSmilingEyes
