package org.kodein.emoji.smileys_emotion.face_tongue

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FaceSavoringFood: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😋",
        description = "face savoring food",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("face-savoring-food", "yum"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-tongue: face savoring food.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FaceSavoringFood: Emoji get() = _FaceSavoringFood

/**
 * Alias to emoji [FaceSavoringFood] (Smileys & Emotion: face-tongue: face savoring food).
*/
public val Emoji.Companion.Yum: Emoji get() = _FaceSavoringFood
