package org.kodein.emoji.smileys_emotion.face_tongue

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _MoneyMouthFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🤑",
        description = "money-mouth face",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("money-mouth-face", "money-face"),
        emoticons = listOf("\$_\$"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-tongue: money-mouth face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MoneyMouthFace: Emoji get() = _MoneyMouthFace

/**
 * Alias to emoji [MoneyMouthFace] (Smileys & Emotion: face-tongue: money-mouth face).
*/
public val Emoji.Companion.MoneyFace: Emoji get() = _MoneyMouthFace
