package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _JapaneseNoVacancyButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🈵",
        description = "Japanese “no vacancy” button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("japanese-no-vacancy-button", "no-vacancy"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: alphanum: Japanese “no vacancy” button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.JapaneseNoVacancyButton: Emoji get() = _JapaneseNoVacancyButton

/**
 * Alias to emoji [JapaneseNoVacancyButton] (Symbols: alphanum: Japanese “no vacancy” button).
*/
public val Emoji.Companion.NoVacancy: Emoji get() = _JapaneseNoVacancyButton
