package org.kodein.emoji.symbols.av_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _EjectButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⏏️",
        description = "eject button",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("eject-button", "eject", "triangle-up-with-horizontal-bar"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: av-symbol: eject button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.EjectButton: Emoji get() = _EjectButton

/**
 * Alias to emoji [EjectButton] (Symbols: av-symbol: eject button).
*/
public val Emoji.Companion.Eject: Emoji get() = _EjectButton

/**
 * Alias to emoji [EjectButton] (Symbols: av-symbol: eject button).
*/
public val Emoji.Companion.TriangleUpWithHorizontalBar: Emoji get() = _EjectButton
