package org.kodein.emoji.symbols.other_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _DoubleCurlyLoop: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "➿",
        description = "double curly loop",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("double-curly-loop", "curly-loop-double"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: other-symbol: double curly loop.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.DoubleCurlyLoop: Emoji get() = _DoubleCurlyLoop

/**
 * Alias to emoji [DoubleCurlyLoop] (Symbols: other-symbol: double curly loop).
*/
public val Emoji.Companion.CurlyLoopDouble: Emoji get() = _DoubleCurlyLoop
