package org.kodein.emoji.symbols.transport_sign

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _LitterInBinSign: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🚮",
        description = "litter in bin sign",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("litter-in-bin-sign", "litter"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: transport-sign: litter in bin sign.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.LitterInBinSign: Emoji get() = _LitterInBinSign

/**
 * Alias to emoji [LitterInBinSign] (Symbols: transport-sign: litter in bin sign).
*/
public val Emoji.Companion.Litter: Emoji get() = _LitterInBinSign
