package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagSierraLeone: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇸🇱",
        description = "flag: Sierra Leone",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-sierra-leone", "sierra-leone-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Sierra Leone.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagSierraLeone: Emoji get() = _FlagSierraLeone

/**
 * Alias to emoji [FlagSierraLeone] (Flags: country-flag: flag: Sierra Leone).
*/
public val Emoji.Companion.SierraLeoneFlag: Emoji get() = _FlagSierraLeone
