package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagSomalia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇸🇴",
        description = "flag: Somalia",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-somalia", "somalia-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Somalia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagSomalia: Emoji get() = _FlagSomalia

/**
 * Alias to emoji [FlagSomalia] (Flags: country-flag: flag: Somalia).
*/
public val Emoji.Companion.SomaliaFlag: Emoji get() = _FlagSomalia
