package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _TShirt: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "👕",
        description = "t-shirt",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("t-shirt", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: clothing: t-shirt.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.TShirt: Emoji get() = _TShirt
