package org.kodein.emoji.people_body.person_role

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _Technologist: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🧑‍💻",
        description = "technologist",
        unicodeVersion = UnicodeVersion(12, 1),
        aliases = listOf("technologist", "person-at-computer"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-role: technologist.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Technologist: SkinTone1Emoji get() = _Technologist

/**
 * Alias to emoji [Technologist] (People & Body: person-role: technologist).
*/
public val Emoji.Companion.PersonAtComputer: SkinTone1Emoji get() = _Technologist
