package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagCroatia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇭🇷",
        description = "flag: Croatia",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-croatia", "croatia-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Croatia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagCroatia: Emoji get() = _FlagCroatia

/**
 * Alias to emoji [FlagCroatia] (Flags: country-flag: flag: Croatia).
*/
public val Emoji.Companion.CroatiaFlag: Emoji get() = _FlagCroatia
