package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagNiue: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇳🇺",
        description = "flag: Niue",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-niue", "niue-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Niue.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagNiue: Emoji get() = _FlagNiue

/**
 * Alias to emoji [FlagNiue] (Flags: country-flag: flag: Niue).
*/
public val Emoji.Companion.NiueFlag: Emoji get() = _FlagNiue
