package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagSlovakia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇸🇰",
        description = "flag: Slovakia",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-slovakia", "slovakia-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Slovakia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagSlovakia: Emoji get() = _FlagSlovakia

/**
 * Alias to emoji [FlagSlovakia] (Flags: country-flag: flag: Slovakia).
*/
public val Emoji.Companion.SlovakiaFlag: Emoji get() = _FlagSlovakia
