package org.kodein.emoji.people_body.hand_single_finger

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.UnqualifiedSkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _IndexPointingUp: SkinTone1Emoji = UnqualifiedSkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "☝️",
        description = "index pointing up",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("index-pointing-up", "index-finger"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
    uqString = "☝",
    sk1c = 1,
)

/**
 * Emoji People & Body: hand-single-finger: index pointing up.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.IndexPointingUp: SkinTone1Emoji get() = _IndexPointingUp

/**
 * Alias to emoji [IndexPointingUp] (People & Body: hand-single-finger: index pointing up).
*/
public val Emoji.Companion.IndexFinger: SkinTone1Emoji get() = _IndexPointingUp
