package org.kodein.emoji.smileys_emotion.face_glasses

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllFaceGlasses() {
    add(intArrayOf(0x1f60e), _SmilingFaceWithSunglasses)
    add(intArrayOf(0x1f913), _NerdFace)
    add(intArrayOf(0x1f9d0), _FaceWithMonocle)
}

internal suspend fun SequenceScope<Emoji>.yieldAllFaceGlasses() {
    yield(_SmilingFaceWithSunglasses)
    yield(_NerdFace)
    yield(_FaceWithMonocle)
}

internal val countFaceGlasses = 3

/**
 * All Emoji of the Smileys & Emotion: face-glasses subgroup.
*/
public fun Emoji.Companion.sequenceFaceGlasses(): Sequence<Emoji> =
    sequence { yieldAllFaceGlasses() }

/**
 * All Emoji of the Smileys & Emotion: face-glasses subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listFaceGlasses(): List<Emoji> =
    ArrayList<Emoji>(countFaceGlasses).also { list -> sequenceFaceGlasses().forEach { list.add(it) } }

@Deprecated("Renamed listFaceGlasses.", replaceWith = ReplaceWith("listFaceGlasses()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allFaceGlasses(): List<Emoji> =
    listFaceGlasses()
