package org.kodein.emoji.symbols.warning

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ChildrenCrossing: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🚸",
        description = "children crossing",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("children-crossing", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: warning: children crossing.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ChildrenCrossing: Emoji get() = _ChildrenCrossing
