package org.kodein.emoji.travel_places.transport_ground

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SportUtilityVehicle: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🚙",
        description = "sport utility vehicle",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("sport-utility-vehicle", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: transport-ground: sport utility vehicle.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SportUtilityVehicle: Emoji get() = _SportUtilityVehicle
