package org.kodein.emoji.activities.award_medal

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FirstPlaceMedal: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🥇",
        description = "1st place medal",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("1st-place-medal", "gold-medal"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Activities: award-medal: 1st place medal.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FirstPlaceMedal: Emoji get() = _FirstPlaceMedal

/**
 * Alias to emoji [FirstPlaceMedal] (Activities: award-medal: 1st place medal).
*/
public val Emoji.Companion.GoldMedal: Emoji get() = _FirstPlaceMedal
