package org.kodein.emoji.animals_nature.animal_mammal

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Lion: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🦁",
        description = "lion",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("lion", "lion-face"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Animals & Nature: animal-mammal: lion.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Lion: Emoji get() = _Lion

/**
 * Alias to emoji [Lion] (Animals & Nature: animal-mammal: lion).
*/
public val Emoji.Companion.LionFace: Emoji get() = _Lion
