package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagCambodia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇰🇭",
        description = "flag: Cambodia",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-cambodia", "cambodia-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5625f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Cambodia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagCambodia: Emoji get() = _FlagCambodia

/**
 * Alias to emoji [FlagCambodia] (Flags: country-flag: flag: Cambodia).
*/
public val Emoji.Companion.CambodiaFlag: Emoji get() = _FlagCambodia
