package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagChad: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇹🇩",
        description = "flag: Chad",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-chad", "chad-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Chad.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagChad: Emoji get() = _FlagChad

/**
 * Alias to emoji [FlagChad] (Flags: country-flag: flag: Chad).
*/
public val Emoji.Companion.ChadFlag: Emoji get() = _FlagChad
