package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagChile: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇨🇱",
        description = "flag: Chile",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-chile", "chile-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Chile.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagChile: Emoji get() = _FlagChile

/**
 * Alias to emoji [FlagChile] (Flags: country-flag: flag: Chile).
*/
public val Emoji.Companion.ChileFlag: Emoji get() = _FlagChile
