package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagKenya: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇰🇪",
        description = "flag: Kenya",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-kenya", "kenya-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Kenya.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagKenya: Emoji get() = _FlagKenya

/**
 * Alias to emoji [FlagKenya] (Flags: country-flag: flag: Kenya).
*/
public val Emoji.Companion.KenyaFlag: Emoji get() = _FlagKenya
